/*! \file tlk_sclk_api_config.h
**********************************************************************************
* Title:                        Discretix Secured Clock Toolkit header file
*
* Filename:                     tlk_sclk_api_config.h
*
* Project, Target, subsystem:   Toolkit, Secured Clock
* 
* Created:                      10.09.2008
*
* Modified:                     10.09.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_SCLK_API_CONFIG_H_
#define _TLK_SCLK_API_CONFIG_H_

#ifdef __cplusplus
extern "C" {
#endif

/************************************************************************/
/* TESTS CONFIGURATION                                                  */
/************************************************************************/
#define TLK_SCLK_TEST_REAL_WORLD_RUN        0
#define TLK_SCLK_TEST_RUN                   1

#define TLK_SCLK_TEST_CONFIG_SUMMARY       ((TLK_SCLK_TEST_REAL_WORLD_RUN) + \
                                            (TLK_SCLK_TEST_RUN))

/************************************************************************/
/* NVS TYPES CONFIGURATION                                              */
/************************************************************************/
#define TLK_SCLK_VNVS_SST                   0
#define TLK_SCLK_VNVS_NVS                   1
#define TLK_SCLK_VNVS_EXT_FILE              0

#define TLK_SCLK_VNVS_CONFIG_SUMMARY       ((TLK_SCLK_VNVS_SST) + \
                                            (TLK_SCLK_VNVS_NVS) + \
                                            (TLK_SCLK_VNVS_EXT_FILE))

/************************************************************************/
/* RTC TYPES CONFIGURATION                                              */
/************************************************************************/
#define TLK_SCLK_RTC_SW_MC                  0
#define TLK_SCLK_RTC_SW_HOST                1

#define TLK_SCLK_RTC_CONFIG_SUMMARY        ((TLK_SCLK_RTC_SW_MC) + \
                                            (TLK_SCLK_RTC_SW_HOST))

/************************************************************************/
/* DRIFT MASTER CLOCK CONFIGURATION                                     */
/************************************************************************/
#define TLK_SCLK_MC_NO_DRIFT                1
#define TLK_SCLK_MC_DRIFT_DEFAULT           0

#define TLK_SCLK_MC_DRIFT_CONFIG_SUMMARY   ((TLK_SCLK_MC_NO_DRIFT) + \
                                            (TLK_SCLK_MC_DRIFT_DEFAULT))

#ifdef __cplusplus
}
#endif /*extern "C"*/
#endif
